// David Eberly, Geometric Tools, Redmond WA 98052
// Copyright (c) 1998-2025
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt
// https://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
// File Version: 8.0.2025.05.10

#pragma once

// DX11/DXGI
#include <Graphics/DX11/DXGIAdapter.h>
#include <Graphics/DX11/DXGIOutput.h>

// DX11/Engine
#include <Graphics/DX11/DX11.h>
#include <Graphics/DX11/DX11Engine.h>
#include <Graphics/DX11/DX11GraphicsObject.h>
#include <Graphics/DX11/DX11PerformanceCounter.h>

// DX11/Engine/InputLayout
#include <Graphics/DX11/DX11InputLayout.h>
#include <Graphics/DX11/DX11InputLayoutManager.h>

// DX11/Engine/Resources
#include <Graphics/DX11/DX11Resource.h>

// DX11/Engine/Resources/Buffers
#include <Graphics/DX11/DX11Buffer.h>
#include <Graphics/DX11/DX11ConstantBuffer.h>
#include <Graphics/DX11/DX11IndexBuffer.h>
#include <Graphics/DX11/DX11IndirectArgumentsBuffer.h>
#include <Graphics/DX11/DX11RawBuffer.h>
#include <Graphics/DX11/DX11StructuredBuffer.h>
#include <Graphics/DX11/DX11TextureBuffer.h>
#include <Graphics/DX11/DX11VertexBuffer.h>

// DX11Engine/Resources/Textures
#include <Graphics/DX11/DX11DrawTarget.h>
#include <Graphics/DX11/DX11Texture.h>
#include <Graphics/DX11/DX11Texture1.h>
#include <Graphics/DX11/DX11Texture1Array.h>
#include <Graphics/DX11/DX11Texture2.h>
#include <Graphics/DX11/DX11Texture2Array.h>
#include <Graphics/DX11/DX11Texture3.h>
#include <Graphics/DX11/DX11TextureArray.h>
#include <Graphics/DX11/DX11TextureCube.h>
#include <Graphics/DX11/DX11TextureCubeArray.h>
#include <Graphics/DX11/DX11TextureDS.h>
#include <Graphics/DX11/DX11TextureRT.h>
#include <Graphics/DX11/DX11TextureSingle.h>

// DX11/Engine/Shaders
#include <Graphics/DX11/DX11ComputeShader.h>
#include <Graphics/DX11/DX11GeometryShader.h>
#include <Graphics/DX11/DX11PixelShader.h>
#include <Graphics/DX11/DX11VertexShader.h>
#include <Graphics/DX11/DX11Shader.h>

// DX11/Engine/State
#include <Graphics/DX11/DX11BlendState.h>
#include <Graphics/DX11/DX11DepthStencilState.h>
#include <Graphics/DX11/DX11DrawingState.h>
#include <Graphics/DX11/DX11RasterizerState.h>
#include <Graphics/DX11/DX11SamplerState.h>

// DX11/HLSL
#include <Graphics/DX11/HLSLBaseBuffer.h>
#include <Graphics/DX11/HLSLByteAddressBuffer.h>
#include <Graphics/DX11/HLSLComputeProgram.h>
#include <Graphics/DX11/HLSLConstantBuffer.h>
#include <Graphics/DX11/HLSLParameter.h>
#include <Graphics/DX11/HLSLFactory.h>
#include <Graphics/DX11/HLSLResource.h>
#include <Graphics/DX11/HLSLResourceBindInfo.h>
#include <Graphics/DX11/HLSLSamplerState.h>
#include <Graphics/DX11/HLSLShader.h>
#include <Graphics/DX11/HLSLShaderFactory.h>
#include <Graphics/DX11/HLSLShaderType.h>
#include <Graphics/DX11/HLSLShaderVariable.h>
#include <Graphics/DX11/HLSLStructuredBuffer.h>
#include <Graphics/DX11/HLSLTexture.h>
#include <Graphics/DX11/HLSLTextureArray.h>
#include <Graphics/DX11/HLSLTextureBuffer.h>
#include <Graphics/DX11/HLSLVisualProgram.h>

