// David Eberly, Geometric Tools, Redmond WA 98052
// Copyright (c) 1998-2025
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt
// https://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
// File Version: 8.0.2025.05.10

#include <Graphics/GTGraphicsPCH.h>
#include <Graphics/FontArialW400H12.h>
using namespace gte;

FontArialW400H12::FontArialW400H12(std::shared_ptr<ProgramFactory> const& factory, int32_t maxMessageLength)
    :
    Font(factory, msWidth, msHeight, reinterpret_cast<uint8_t const*>(msTexels), msCharacterData, maxMessageLength)
{
}

int32_t FontArialW400H12::msWidth = 1666;
int32_t FontArialW400H12::msHeight = 12;

uint8_t FontArialW400H12::msTexels[19992] =
{
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0, 
  0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 
255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0, 
  0,   0, 255, 255,   0,   0,   0, 255,   0,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
  0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0, 
  0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 
255,   0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
  0, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0, 255,   0, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255,   0,   0,   0, 
  0,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255,   0, 
255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255,   0, 255, 255, 
  0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
255, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255,   0,   0, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 
255,   0, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 
  0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0, 
  0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 
  0, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
  0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 
255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 
255,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0, 
  0, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255,   0, 
  0, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255,   0, 255,   0,   0, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
  0, 255, 255,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255,   0, 
255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
  0, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255,   0, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0, 
  0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0,   0,   0,   0, 255,   0, 255, 255,   0, 255,   0, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255,   0,   0,   0, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
  0,   0,   0, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0,   0, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0,   0,   0, 255, 255, 
  0,   0,   0, 255,   0,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255,   0, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255,   0, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
  0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0, 
  0,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 255, 255, 
  0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0, 255, 
  0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0,   0,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 
  0, 255,   0, 255, 255,   0, 255,   0, 255,   0, 255, 255,   0, 255,   0,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255,   0, 255, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 
255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
  0,   0,   0,   0,   0, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255,   0,   0,   0, 255, 255, 255,   0, 255,   0, 255, 255,   0,   0,   0,   0, 
  0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 
255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 
255,   0,   0, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 
};

float FontArialW400H12::msCharacterData[257] =
{
0.000300f, 0.005102f, 0.009904f, 0.014706f, 0.019508f, 0.024310f, 0.029112f, 0.033914f, 
0.038715f, 0.043517f, 0.048319f, 0.053121f, 0.057923f, 0.062725f, 0.067527f, 0.072329f, 
0.077131f, 0.081933f, 0.086735f, 0.091537f, 0.096339f, 0.101140f, 0.105942f, 0.110744f, 
0.115546f, 0.120348f, 0.125150f, 0.129952f, 0.134754f, 0.139556f, 0.144358f, 0.149160f, 
0.153962f, 0.156363f, 0.158763f, 0.161164f, 0.164766f, 0.168367f, 0.173770f, 0.177971f, 
0.179772f, 0.182173f, 0.184574f, 0.187575f, 0.191176f, 0.193577f, 0.195978f, 0.198379f, 
0.200780f, 0.204382f, 0.207983f, 0.211585f, 0.215186f, 0.218788f, 0.222389f, 0.225990f, 
0.229592f, 0.233193f, 0.236795f, 0.239196f, 0.241597f, 0.245198f, 0.248800f, 0.252401f, 
0.256002f, 0.262005f, 0.266206f, 0.270408f, 0.275210f, 0.280012f, 0.284214f, 0.288415f, 
0.293217f, 0.298019f, 0.300420f, 0.304022f, 0.308223f, 0.311825f, 0.316627f, 0.321429f, 
0.326230f, 0.330432f, 0.335234f, 0.340036f, 0.344238f, 0.347839f, 0.352641f, 0.356843f, 
0.362845f, 0.366447f, 0.371248f, 0.375450f, 0.377851f, 0.380252f, 0.382653f, 0.385054f, 
0.388655f, 0.391056f, 0.394658f, 0.398259f, 0.401861f, 0.405462f, 0.409064f, 0.412065f, 
0.415666f, 0.419268f, 0.421068f, 0.422869f, 0.426471f, 0.428271f, 0.433673f, 0.437275f, 
0.440876f, 0.444478f, 0.448079f, 0.450480f, 0.454082f, 0.456483f, 0.460084f, 0.464286f, 
0.468487f, 0.472089f, 0.476290f, 0.479292f, 0.481693f, 0.484094f, 0.486495f, 0.490096f, 
0.494898f, 0.499700f, 0.504502f, 0.509304f, 0.514106f, 0.518908f, 0.523709f, 0.528511f, 
0.533313f, 0.538115f, 0.542917f, 0.547719f, 0.552521f, 0.557323f, 0.562125f, 0.566927f, 
0.571729f, 0.576531f, 0.581333f, 0.586134f, 0.590936f, 0.595738f, 0.600540f, 0.605342f, 
0.610144f, 0.614946f, 0.619748f, 0.624550f, 0.629352f, 0.634154f, 0.638956f, 0.643757f, 
0.648559f, 0.650960f, 0.653361f, 0.656963f, 0.660564f, 0.664166f, 0.667767f, 0.670168f, 
0.673769f, 0.676170f, 0.680972f, 0.683373f, 0.686975f, 0.690576f, 0.692977f, 0.697779f, 
0.701381f, 0.704382f, 0.707983f, 0.710384f, 0.712785f, 0.715186f, 0.718787f, 0.722389f, 
0.724790f, 0.727191f, 0.729592f, 0.731993f, 0.735594f, 0.740996f, 0.746399f, 0.751801f, 
0.756002f, 0.760204f, 0.764406f, 0.768607f, 0.772809f, 0.777011f, 0.781212f, 0.787215f, 
0.791417f, 0.795618f, 0.799820f, 0.804022f, 0.808223f, 0.810624f, 0.813025f, 0.815426f, 
0.817827f, 0.822029f, 0.826230f, 0.831032f, 0.835834f, 0.840636f, 0.845438f, 0.850240f, 
0.853841f, 0.858643f, 0.862845f, 0.867047f, 0.871248f, 0.875450f, 0.879652f, 0.883853f, 
0.888055f, 0.891657f, 0.895258f, 0.898860f, 0.902461f, 0.906062f, 0.909664f, 0.915066f, 
0.918667f, 0.922269f, 0.925870f, 0.929472f, 0.933073f, 0.935474f, 0.937875f, 0.940276f, 
0.942677f, 0.946278f, 0.949880f, 0.953481f, 0.957083f, 0.960684f, 0.964286f, 0.967887f, 
0.971489f, 0.975090f, 0.978691f, 0.982293f, 0.985894f, 0.989496f, 0.993097f, 0.996699f, 
1.000300f, 
};

