// David Eberly, Geometric Tools, Redmond WA 98052
// Copyright (c) 1998-2025
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt
// https://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
// File Version: 8.0.2025.05.10

#include <Graphics/GTGraphicsPCH.h>
#include <Graphics/FontArialW400H18.h>
using namespace gte;

FontArialW400H18::FontArialW400H18(std::shared_ptr<ProgramFactory> const& factory, int32_t maxMessageLength)
    :
    Font(factory, msWidth, msHeight, reinterpret_cast<uint8_t const*>(msTexels), msCharacterData, maxMessageLength)
{
}

int32_t FontArialW400H18::msWidth = 2651;
int32_t FontArialW400H18::msHeight = 18;

uint8_t FontArialW400H18::msTexels[47718] =
{
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0,   0,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255,   0,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255,   0, 255, 255, 255,   0, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 
255,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
  0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 
  0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255,   0, 255, 255, 255, 
255,   0,   0,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
  0, 255, 255, 255, 255,   0,   0,   0,   0, 255,   0, 255, 255, 255, 255,   0, 
  0,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255,   0, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
  0, 255, 255, 255, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0, 
  0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 255, 
255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
  0, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0,   0, 255,   0, 255, 255, 255,   0, 
  0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
  0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0,   0,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255,   0, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255,   0,   0,   0, 255,   0, 255, 255, 255,   0, 255,   0,   0,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 
  0,   0,   0, 255, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255,   0, 255, 255, 255,   0, 255, 
  0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
  0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
  0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0,   0, 
  0,   0, 255, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255,   0, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 
};

float FontArialW400H18::msCharacterData[257] =
{
0.000189f, 0.005092f, 0.009996f, 0.014900f, 0.019804f, 0.024708f, 0.029611f, 0.034515f, 
0.039419f, 0.044323f, 0.049227f, 0.054131f, 0.059034f, 0.063938f, 0.068842f, 0.073746f, 
0.078650f, 0.083553f, 0.088457f, 0.093361f, 0.098265f, 0.103169f, 0.108072f, 0.112976f, 
0.117880f, 0.122784f, 0.127688f, 0.132591f, 0.137495f, 0.142399f, 0.147303f, 0.152207f, 
0.157111f, 0.158997f, 0.161260f, 0.163900f, 0.167673f, 0.171445f, 0.177103f, 0.181630f, 
0.183138f, 0.185402f, 0.187665f, 0.190306f, 0.194078f, 0.195964f, 0.198227f, 0.200113f, 
0.201999f, 0.205771f, 0.209544f, 0.213316f, 0.217088f, 0.220860f, 0.224632f, 0.228404f, 
0.232177f, 0.235949f, 0.239721f, 0.241607f, 0.243493f, 0.247265f, 0.251037f, 0.254809f, 
0.258582f, 0.264994f, 0.269521f, 0.274048f, 0.278951f, 0.283855f, 0.288382f, 0.292531f, 
0.297435f, 0.301962f, 0.303470f, 0.306865f, 0.311392f, 0.315164f, 0.320445f, 0.324972f, 
0.329876f, 0.334402f, 0.339306f, 0.343833f, 0.348359f, 0.352131f, 0.356658f, 0.361184f, 
0.367220f, 0.371747f, 0.375519f, 0.379291f, 0.381177f, 0.383063f, 0.384949f, 0.387967f, 
0.391739f, 0.394002f, 0.397774f, 0.401547f, 0.404942f, 0.408714f, 0.412486f, 0.414372f, 
0.418144f, 0.421539f, 0.423425f, 0.424934f, 0.428329f, 0.429838f, 0.435119f, 0.438514f, 
0.442286f, 0.446058f, 0.449830f, 0.452094f, 0.455489f, 0.457375f, 0.460770f, 0.463787f, 
0.468314f, 0.471332f, 0.474349f, 0.477367f, 0.479630f, 0.481139f, 0.483402f, 0.487175f, 
0.492078f, 0.496982f, 0.501886f, 0.506790f, 0.511694f, 0.516598f, 0.521501f, 0.526405f, 
0.531309f, 0.536213f, 0.541117f, 0.546020f, 0.550924f, 0.555828f, 0.560732f, 0.565636f, 
0.570539f, 0.575443f, 0.580347f, 0.585251f, 0.590155f, 0.595058f, 0.599962f, 0.604866f, 
0.609770f, 0.614674f, 0.619578f, 0.624481f, 0.629385f, 0.634289f, 0.639193f, 0.644097f, 
0.649000f, 0.650886f, 0.653150f, 0.656922f, 0.660694f, 0.664466f, 0.668238f, 0.669747f, 
0.673519f, 0.675783f, 0.680687f, 0.682950f, 0.686722f, 0.690494f, 0.692757f, 0.697661f, 
0.701433f, 0.704074f, 0.707846f, 0.710109f, 0.712373f, 0.714636f, 0.718408f, 0.722180f, 
0.724444f, 0.726707f, 0.728970f, 0.731233f, 0.735006f, 0.740287f, 0.745568f, 0.750849f, 
0.754998f, 0.759525f, 0.764051f, 0.768578f, 0.773104f, 0.777631f, 0.782158f, 0.788570f, 
0.793474f, 0.798001f, 0.802527f, 0.807054f, 0.811581f, 0.813089f, 0.814598f, 0.816107f, 
0.817616f, 0.822520f, 0.827046f, 0.831950f, 0.836854f, 0.841758f, 0.846662f, 0.851565f, 
0.855338f, 0.860241f, 0.864768f, 0.869295f, 0.873821f, 0.878348f, 0.882120f, 0.886647f, 
0.890419f, 0.894191f, 0.897963f, 0.901735f, 0.905507f, 0.909280f, 0.913052f, 0.918710f, 
0.922105f, 0.925877f, 0.929649f, 0.933421f, 0.937194f, 0.938702f, 0.940211f, 0.941720f, 
0.943229f, 0.947001f, 0.950396f, 0.954168f, 0.957940f, 0.961713f, 0.965485f, 0.969257f, 
0.973029f, 0.976801f, 0.980196f, 0.983591f, 0.986986f, 0.990381f, 0.993399f, 0.997171f, 
1.000189f, 
};

