// David Eberly, Geometric Tools, Redmond WA 98052
// Copyright (c) 1998-2025
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt
// https://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
// File Version: 8.0.2025.05.10

#include <Graphics/GTGraphicsPCH.h>
#include <Graphics/FontArialW700H16.h>
using namespace gte;

FontArialW700H16::FontArialW700H16(std::shared_ptr<ProgramFactory> const& factory, int32_t maxMessageLength)
    :
    Font(factory, msWidth, msHeight, reinterpret_cast<uint8_t const*>(msTexels), msCharacterData, maxMessageLength)
{
}

int32_t FontArialW700H16::msWidth = 2297;
int32_t FontArialW700H16::msHeight = 16;

uint8_t FontArialW700H16::msTexels[36752] =
{
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 225, 104, 255, 104, 225, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 208, 154,  77,   0,   0,  77, 154, 208, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 217, 104,   0,   0, 140, 233, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 140,   0, 104, 217, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 104, 189, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 233, 154,   0,   0, 255, 255, 255, 255, 255,   0,   0, 
154, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 104, 240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 233, 104,   0, 104, 233, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 104,   0,   0, 
124, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 208, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 104, 189, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 104, 189, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 
178, 255, 178, 124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 140, 225, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
140, 225, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 124, 140, 208, 240, 255, 255, 
255, 217, 154, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  77, 199, 255, 233, 
  0, 154, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 240,   0, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233,  77, 
  0, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 124,   0, 
233, 255, 255, 255,   0, 255, 255, 255, 233,   0, 124, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 154, 217, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 104, 
  0, 233,   0, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 240,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 178,   0, 199, 255, 208,   0, 124, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 240,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 233,  77,   0, 208, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 233,  77,   0, 208, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 233,   0, 208, 255, 208,   0, 233, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
233, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 104, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 104, 199, 255, 255, 255, 255, 255, 255, 255, 255, 208, 140, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
233, 154, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 124,   0, 124, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 199, 178, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,  77, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,  77, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 225, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  77, 140, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 225, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 124,   0, 
124, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 124, 
  0, 124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,  77, 255, 255,  77, 255, 255, 255, 255, 255, 217, 
104,   0, 104, 233, 255, 255, 255, 255, 225, 154, 255, 255, 199,   0, 199, 255, 
255, 255, 255, 167,   0,   0, 124, 199, 124, 167, 255, 255, 255, 255, 255, 255, 
178,   0, 225, 255, 225,   0, 178, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 104, 240, 255, 255, 255, 255, 154,   0,   0, 
167, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,  77,   0,   0,   0, 
  0,   0, 255, 255, 233, 140,   0,  77, 178, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 233, 140,   0,  77, 178, 255, 255, 255, 255, 167,   0,   0, 
167, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 167,   0,   0, 
167, 255, 255, 255, 233, 104,   0, 104, 208, 255, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 199, 154, 233, 140,   0, 140, 
208,  77,   0, 140, 217, 255, 255, 255, 104,   0, 233, 255, 255, 255, 233,   0, 
104, 255, 255,   0,   0,   0,   0,   0, 154, 255, 255, 255, 255, 255, 255, 167, 
  0,   0, 104, 189, 255, 255, 255,   0,   0,   0,   0, 124, 217, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 167,  77,   0,  77, 154, 208, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 140,   0,   0, 
167, 255, 255, 255, 255,   0,   0, 255, 255, 255, 140,   0, 225, 255, 255,   0, 
  0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 199,   0, 199, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,  77,   0, 255, 255, 255, 255, 233, 
154,   0,   0, 154, 233, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 233, 154,   0,   0, 140,  77, 208, 255, 255, 255,   0,   0, 
255, 255, 255, 189,   0, 140, 255, 255, 233, 154,   0,   0,  77, 167, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 178,  77,   0,  77, 
178, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
 77,   0, 124, 255, 255, 255, 104,   0,   0, 255, 255, 255, 225,   0, 124, 255, 
255, 255, 124,   0, 225, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 
  0,   0,   0,   0,   0,   0, 255, 255,   0,   0, 255, 255, 255, 255, 240, 104, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 208,  77,  77, 
178,   0,   0, 255, 255, 255,   0,   0, 217,  77, 124, 255, 255, 255, 255, 255, 
178,   0,   0, 140, 233, 255, 255, 255, 140,  77, 208,   0,   0, 255, 255, 255, 
255, 167,   0,   0, 140, 233, 255, 255, 255,   0,   0, 255, 255, 255, 255, 140, 
104, 208,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 104,  77, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 255, 178,  77, 
 77, 178, 255, 255, 255, 255,   0,   0, 208,   0, 140, 255, 255, 255, 255, 255, 
140,  77, 208,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 240, 154,   0, 
  0, 124, 233, 255, 255, 208,   0, 124, 255, 255, 208,  77, 104, 225,   0,   0, 
255, 255, 255, 255, 167,   0, 167, 255, 255, 255, 255, 255,  77,   0, 189, 255, 
199,   0,  77, 255, 255, 255, 233,   0, 140, 255, 255, 140,   0, 225, 255, 255, 
255,   0,   0,   0, 240, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 104, 255, 255, 255, 167,   0, 
  0, 140, 233, 255, 255, 225, 167, 255, 217, 124,   0, 189, 255, 167, 255, 255, 
255, 255, 167, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 124,   0, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
217, 140,   0,   0, 140, 217, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
217, 104, 255, 217, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 217, 140,   0,   0, 140, 217, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 124, 124,   0,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 217, 255, 104, 217, 
255, 255, 255, 154, 217, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 154, 
217, 255, 255, 255, 104,   0,   0,   0, 255, 255, 255, 255, 225, 140, 255, 255, 
255, 255, 255,   0, 255, 255, 104,   0, 208, 255, 255, 255, 255, 255, 255, 104, 
  0, 233, 255, 255, 255, 233,   0, 104, 255, 104,   0, 233, 255, 255, 255, 233, 
  0, 104, 255, 104,   0, 233, 255, 255, 255, 233,   0, 104, 255, 104,   0, 233, 
255, 255, 255, 233,   0, 104, 255, 104,   0, 233, 255, 255, 255, 233,   0, 104, 
255, 104,   0, 233, 255, 255, 255, 233,   0, 104, 255, 124,   0, 233, 255, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 167,   0,   0, 104, 
189, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
  0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 
  0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
124, 217, 255, 255, 255, 255,   0,   0, 255, 255, 255,  77,   0, 255, 255, 255, 
255, 233, 154,   0,   0, 154, 233, 255, 255, 255, 255, 255, 233, 154,   0,   0, 
154, 233, 255, 255, 255, 255, 255, 233, 154,   0,   0, 154, 233, 255, 255, 255, 
255, 255, 233, 154,   0,   0, 154, 233, 255, 255, 255, 255, 255, 233, 154,   0, 
  0, 154, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 208, 
  0, 167, 104,   0,   0, 154, 233, 255, 255, 255, 255, 255, 178,  77,   0,  77, 
178, 255, 255, 255, 255, 255, 178,  77,   0,  77, 178, 255, 255, 255, 255, 255, 
178,  77,   0,  77, 178, 255, 255, 255, 255, 255, 178,  77,   0,  77, 178, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 208,  77,  77, 217, 255, 255, 255, 208, 
 77,  77, 178,   0,   0, 255, 255, 255, 208,  77,  77, 178,   0,   0, 255, 255, 
255, 208,  77,  77, 178,   0,   0, 255, 255, 255, 208,  77,  77, 178,   0,   0, 
255, 255, 255, 208,  77,  77, 178,   0,   0, 255, 255, 255, 208,  77,  77, 178, 
  0,   0, 255, 255, 255, 225, 104,   0, 140, 208, 167,   0,   0, 140, 233, 255, 
255, 255, 255, 178,   0,   0, 140, 233, 255, 255, 255, 167,   0,   0, 140, 233, 
255, 255, 255, 255, 167,   0,   0, 140, 233, 255, 255, 255, 255, 167,   0,   0, 
140, 233, 255, 255, 255, 255, 167,   0,   0, 140, 233, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 178,   0,  77, 178, 255, 255, 255, 255,   0,   0, 255, 255,   0, 
  0, 255, 255, 255, 255, 178,  77,  77, 178, 255, 255, 255, 255, 255, 178,  77, 
 77, 178, 255, 255, 255, 255, 255, 178,  77,  77, 178, 255, 255, 255, 255, 255, 
178,  77,  77, 178, 255, 255, 255, 255, 255, 178,  77,  77, 178, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 208,   0,   0,   0, 124, 233, 255, 
255, 255, 208,  77, 104, 225,   0,   0, 255, 255, 255, 208,  77, 104, 225,   0, 
  0, 255, 255, 255, 208,  77, 104, 225,   0,   0, 255, 255, 255, 208,  77, 104, 
225,   0,   0, 255, 255, 255, 255,   0,   0,   0, 240, 255, 255, 255,   0,   0, 
178,   0, 140, 255, 255, 255, 255, 255,   0,   0,   0, 240, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 
225, 255, 140, 225, 255, 255, 255, 255, 104, 208,   0, 225, 154, 255, 255, 255, 
255, 255, 104, 240, 255,  77, 240,  77, 255, 255, 255, 167,   0, 225, 233,   0, 
  0,  77, 225, 255, 255, 255, 255, 255, 255, 140,   0, 255, 255, 255,   0, 140, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
178, 199, 255, 255, 255, 189,   0, 199, 199,   0, 178, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 167,   0, 199, 255, 255, 255, 255, 255, 140,   0, 233, 
199,   0, 178, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 124,   0, 233, 
199,   0, 167, 255, 255, 189,   0, 199, 225,   0, 167, 255, 255, 255, 104,   0, 
240, 255, 255, 255, 255, 167,   0, 199, 217,   0, 167, 255, 255, 154,   0, 233, 
199,   0, 225, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 217, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 140, 217, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 124, 225, 140,   0,   0,   0,   0,   0,   0, 255, 167, 167, 255, 
255, 178,   0, 199, 255, 255, 255, 199,   0, 178, 255, 255,   0,   0, 255, 255, 
208,   0, 167, 255, 255, 255, 255,  77, 104, 240, 255, 199,   0, 140, 255, 255, 
  0,   0, 255, 255, 154,   0, 233, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 124,  77, 233, 
255, 199,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 154,   0, 225, 225,   0, 167, 255, 255, 255,   0,   0, 
255, 255, 233,   0, 104, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 167,   0, 167, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 189,   0,   0, 255, 255, 255, 240,  77, 104, 240, 240, 104,  77, 240, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 240,  77,  77, 233, 
199,   0,   0, 225, 255, 255, 255,   0,   0, 255, 255, 255,  77,   0, 240, 255, 
255, 104,   0, 217, 255, 208,   0, 167, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 189,   0, 189, 255, 199,   0, 178, 255, 255, 255, 255, 208, 
  0,   0,   0, 208, 255, 255, 255, 255, 233,   0,   0,   0, 255, 255, 255,   0, 
  0,   0, 233, 255, 255, 255, 167,   0, 199, 255, 199,   0, 167, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 154,   0, 189, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 199, 178, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,  77,   0, 233, 199,   0,   0, 255, 255, 255,   0, 
  0, 167, 208,   0, 167, 255, 255, 255, 178,   0, 199, 233,   0, 124, 255, 255, 
167,   0, 199, 189,   0,   0, 255, 255, 255, 167,   0, 199, 233,   0, 104, 255, 
255, 255,   0,   0, 255, 255, 255, 167,   0, 199, 167,   0,   0, 255, 255, 255, 
  0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 178,   0, 189, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255,   0,   0, 255, 255, 255, 189,   0, 199, 199,   0, 189, 255, 255, 255,   0, 
  0, 167, 208,   0, 167, 255, 255, 255, 167,   0, 208, 167,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255, 124,   0, 233, 240,   0, 104, 255, 255,   0,   0, 
255, 255, 255, 104,   0, 233, 189,   0,   0, 255, 255, 255, 255,   0,   0,   0, 
240, 255, 255, 255, 233,   0,   0, 140, 255, 154,   0,   0, 233, 255, 255, 255, 
178,   0, 225, 225,   0, 167, 255, 255, 255, 208,   0,   0,   0, 208, 255, 255, 
255, 140,   0, 225, 255, 255, 255, 255, 255,   0,  77, 255, 255, 255, 255,   0, 
255, 255, 255, 255,  77,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 140, 140, 255, 255, 189,   0,   0, 208, 199, 124, 255, 255, 154,   0, 
  0,  77, 167, 225, 167, 167,   0,   0,   0,   0,   0,   0, 167, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 124,   0,   0, 104, 233, 
255, 255, 255, 255, 255, 255, 255, 255, 167, 124, 217, 255, 255, 217, 124, 167, 
255, 255, 255, 255, 255, 255, 255, 255, 255,  77, 178, 255,  77, 178, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 
124, 217, 255, 255, 217, 124, 167, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
217, 199,   0,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 178,  77, 255, 178,  77, 255, 255, 255, 240, 104, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 240, 124, 255, 255, 255, 233, 167, 240, 
255, 255, 255, 255, 255, 255, 154, 225, 255, 255,   0,   0,   0,   0, 255, 233, 
104,  77, 233, 255, 255, 255, 255, 255, 178,   0, 199, 255, 255, 255, 199,   0, 
178, 255, 178,   0, 199, 255, 255, 255, 199,   0, 178, 255, 178,   0, 199, 255, 
255, 255, 199,   0, 178, 255, 178,   0, 199, 255, 255, 255, 199,   0, 178, 255, 
178,   0, 199, 255, 255, 255, 199,   0, 178, 255, 178,   0, 199, 255, 255, 255, 
199,   0, 178, 255, 208,   0, 167, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255,  77, 104, 240, 255, 199,   0, 140, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 154,   0, 225, 255, 255, 255,   0, 
  0, 255, 255, 189,   0,   0, 255, 255, 255, 240,  77, 104, 240, 240, 104,  77, 
240, 255, 255, 255, 240,  77, 104, 240, 240, 104,  77, 240, 255, 255, 255, 240, 
 77, 104, 240, 240, 104,  77, 240, 255, 255, 255, 240,  77, 104, 240, 240, 104, 
 77, 240, 255, 255, 255, 240,  77, 104, 240, 240, 104,  77, 240, 255, 255, 233, 
104, 233, 255, 233, 104, 233, 255, 255, 255, 124,   0, 124, 255, 240, 104,  77, 
240, 255, 255, 255, 189,   0, 189, 255, 199,   0, 178, 255, 255, 255, 189,   0, 
189, 255, 199,   0, 178, 255, 255, 255, 189,   0, 189, 255, 199,   0, 178, 255, 
255, 255, 189,   0, 189, 255, 199,   0, 178, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 208, 199,   0, 104, 255, 255, 255,  77,   0, 233, 199,   0,   0, 255, 255, 
255,  77,   0, 233, 199,   0,   0, 255, 255, 255,  77,   0, 233, 199,   0,   0, 
255, 255, 255,  77,   0, 233, 199,   0,   0, 255, 255, 255,  77,   0, 233, 199, 
  0,   0, 255, 255, 255,  77,   0, 233, 199,   0,   0, 255, 255, 255, 104,   0, 
233, 199,   0,   0, 199, 233,   0, 104, 255, 255, 255, 178,   0, 199, 233,   0, 
124, 255, 255, 167,   0, 199, 233,   0, 104, 255, 255, 255, 167,   0, 199, 233, 
  0, 104, 255, 255, 255, 167,   0, 199, 233,   0, 104, 255, 255, 255, 167,   0, 
199, 233,   0, 104, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 189,   0, 199, 199,   0, 
189, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 189,   0, 199, 
199,   0, 189, 255, 255, 255, 189,   0, 199, 199,   0, 189, 255, 255, 255, 189, 
  0, 199, 199,   0, 189, 255, 255, 255, 189,   0, 199, 199,   0, 189, 255, 255, 
255, 189,   0, 199, 199,   0, 189, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 225,   0, 167, 208,   0, 154, 255, 255, 255, 104,   0, 233, 189,   0, 
  0, 255, 255, 255, 104,   0, 233, 189,   0,   0, 255, 255, 255, 104,   0, 233, 
189,   0,   0, 255, 255, 255, 104,   0, 233, 189,   0,   0, 255, 255, 255, 208, 
  0,   0,   0, 208, 255, 255, 255,   0,   0, 199, 208,   0, 167, 255, 255, 255, 
208,   0,   0,   0, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 189, 189, 255, 189, 189, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 199, 189, 255,   0, 255, 
  0, 255, 255, 255,   0,   0, 255, 233,   0,   0,  77, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 225, 140, 255, 255, 255, 124,   0, 
255, 255,   0, 124, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 240,   0, 
 77, 233, 255, 255, 255, 255, 255, 255, 255, 255,   0,  77, 255, 255,   0,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,  77, 255, 255, 124,   0, 
255, 255,   0,   0, 255, 255, 255, 140,   0, 225, 255, 255, 255, 255,   0,   0, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 154, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 208, 104,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  77,   0, 104, 208, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0,   0, 
233, 255, 167,   0,   0, 225, 255, 140, 217, 255, 233,   0,   0,   0,   0,   0, 
  0,   0, 233, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 178, 
  0, 217, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 217,   0, 167, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 189,   0, 208, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 
255, 255,   0,  77, 255, 255, 255,   0,   0, 255, 255, 167,   0, 208, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 104,   0, 104, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255,  77,   0,   0, 255, 255, 255, 
167,   0, 208, 255, 255, 208,   0, 167, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 167,   0, 208, 255, 154, 208,   0, 154, 255, 255, 255, 
  0,   0, 255, 255, 189,   0, 178, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 104,   0, 255, 
255, 255,   0, 104, 255, 255, 255, 255, 154,   0, 140,   0, 154, 255, 255, 255, 
255, 208,   0,   0,   0, 217, 255, 217,   0,   0,   0, 199, 255, 255, 255, 255, 
 77,  77, 240,  77,  77, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 240,  77,  77, 240, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
140, 225, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,  77, 255, 255, 
255,  77,   0, 255, 255, 255, 255, 255, 255,  77,   0, 255, 255,   0,   0, 255, 
255, 255,  77,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
 77,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 208,   0, 
124, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 104, 
  0, 255, 255,   0, 104, 255, 255, 255,   0,   0, 255, 255,   0,  77, 255, 255, 
255,  77,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 217, 167,   0,  77, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
  0,   0, 255, 255, 255, 189,   0, 140,   0, 189, 255, 255, 255, 178,   0,   0, 
  0, 255,   0,   0,   0, 178, 255, 255, 255, 255,  77, 154, 140,  77, 240, 255, 
255, 255, 154,   0, 140,   0, 154, 255, 255, 255, 240,   0, 104, 255, 255, 255, 
255, 225,   0, 178, 255, 255, 255, 255,   0, 255, 255, 255, 255, 178,   0, 225, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 140, 255, 255,  77, 
  0, 217, 189, 255, 255, 255, 255, 255, 178,   0, 178, 255, 255, 255, 255,   0, 
167, 255, 255, 167,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 178,   0,   0, 217,   0, 104, 255, 255, 255, 255, 255, 255, 255, 
217, 124, 255, 233, 104,  77, 217, 255, 124, 217, 255, 255, 255, 255, 255, 255, 
255, 154,   0, 217, 154,   0, 217, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 217, 124, 255,   0, 255, 217, 124, 255, 124, 
217, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225,   0, 154, 
225,   0, 154, 255, 255, 255, 189, 189, 255, 255, 167, 217,   0, 255, 255, 255, 
255, 255, 189, 189, 255, 255, 255, 255, 140, 208, 255, 255, 255, 255, 255, 240, 
104, 255, 255, 167, 217,   0, 255, 255, 255, 255, 167,  77, 225, 255, 255, 255, 
255, 233,   0,   0,   0,   0,   0,   0,   0, 233, 255, 233,   0,   0,   0,   0, 
  0,   0,   0, 233, 255, 233,   0,   0,   0,   0,   0,   0,   0, 233, 255, 233, 
  0,   0,   0,   0,   0,   0,   0, 233, 255, 233,   0,   0,   0,   0,   0,   0, 
  0, 233, 255, 233,   0,   0,   0,   0,   0,   0,   0, 233, 255, 255,  77,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 178,   0, 217, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 225,   0, 167, 255, 255, 255,   0,   0, 255, 255,  77,   0,   0, 255, 
255, 255, 167,   0, 208, 255, 255, 208,   0, 167, 255, 255, 255, 167,   0, 208, 
255, 255, 208,   0, 167, 255, 255, 255, 167,   0, 208, 255, 255, 208,   0, 167, 
255, 255, 255, 167,   0, 208, 255, 255, 208,   0, 167, 255, 255, 255, 167,   0, 
208, 255, 255, 208,   0, 167, 255, 255, 233,  77,  77, 208,  77,  77, 233, 255, 
255, 255, 124,   0, 124, 255, 255, 208,   0, 167, 255, 255, 255, 104,   0, 255, 
255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255, 255,   0, 104, 255, 255, 
255, 104,   0, 255, 255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255, 255, 
  0, 104, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0, 167, 255, 255, 255, 255,   0,   0, 255, 225,   0,   0, 255, 255, 
255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255,  77,   0, 255, 255, 255, 255, 255, 255,  77,   0, 255, 255, 
255, 255, 255, 255, 255,  77,   0, 255, 255, 255, 255, 255, 255, 255,  77,   0, 
255, 255, 255, 255, 255, 255, 255,  77,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255, 104,   0, 255, 255,   0, 104, 255, 255, 255,   0,   0, 255, 
255,   0,   0, 255, 255, 255, 104,   0, 255, 255,   0, 104, 255, 255, 255, 104, 
  0, 255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255,   0, 104, 255, 255, 
255, 104,   0, 255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255,   0, 104, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 140,   0,   0, 225,   0, 
 77, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255, 154,   0, 140,   0, 154, 255, 255, 255, 
  0,   0, 255, 255,   0,  77, 255, 255, 255, 154,   0, 140,   0, 154, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 189, 189, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 167,   0, 255, 
255, 255, 255, 255, 255, 104, 255,  77, 240,  77, 255, 255, 255,  77,   0, 225, 
167,   0, 104,   0, 225, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,  77, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 199,   0,  77, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 140, 208, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 
189,   0, 178, 255, 255, 255, 255,  77,   0, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,  77, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 189,  77,   0, 124, 199, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 208, 140,   0,  77, 189, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255,   0, 255,  77,   0, 255, 255, 240,   0,   0, 189, 255, 
233, 124, 255, 255, 104,   0, 240, 255, 255,   0, 104, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255, 104,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255,   0,  77, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 124,   0, 
240, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 225, 255,   0,  77, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255,   0, 104,   0, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 189,   0,   0,   0, 255, 255, 255, 104,   0, 255, 255, 255, 255,   0, 
104, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 104,   0, 
240, 255, 255, 255,   0,  77, 255, 255, 255,   0,   0, 255, 225,   0, 124, 255, 
255, 255, 255, 255, 255, 255, 225, 104,   0,  77, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
255,  77,   0, 240,   0,   0, 255, 255, 255, 255, 167,   0, 104,   0, 178, 255, 
178,   0, 140,   0, 167, 255, 255, 255, 255, 199,   0,   0,   0, 199, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 199,   0, 154, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255,  77, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 208,   0, 154, 233,   0,   0, 255, 255, 
255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0,   0,   0, 225, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255, 208,  77,   0,   0,  77, 208, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,  77,  77, 
240,  77,  77, 255, 255, 255, 104,   0, 208,   0, 189,   0, 217,   0, 104, 255, 
255, 255, 255, 199,   0,   0, 178, 255, 255, 255, 255,  77,   0, 240,   0,  77, 
255, 255, 255, 255, 189,   0, 189, 255, 255, 255,   0, 104, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 104,   0, 255, 189, 255, 240, 189,  77,  77, 
199, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 189, 189, 255, 255,   0,   0, 225, 154, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,  77,   0, 199, 233, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 140, 217, 255, 140, 217, 225, 104, 
255, 217, 140, 255, 255, 255, 255, 255, 255, 255, 154,   0, 225, 154,   0, 225, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
140, 217, 255,   0, 255,  77, 208, 255, 217, 140, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 217,   0, 154, 217,   0, 154, 255, 255, 255, 255, 
124, 255, 255, 255, 124,   0, 255, 255, 255, 255, 255, 255, 104, 240, 255,  77, 
233, 255,   0, 255, 255, 255, 255, 255, 255, 189, 199, 255, 255, 124,   0, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 104,   0, 240, 255, 255, 
  0, 104, 255, 255, 255, 104,   0, 240, 255, 255,   0, 104, 255, 255, 255, 104, 
  0, 240, 255, 255,   0, 104, 255, 255, 255, 104,   0, 240, 255, 255,   0, 104, 
255, 255, 255, 104,   0, 240, 255, 255,   0, 104, 255, 255, 255, 104,   0, 240, 
255, 255,   0, 104, 255, 255, 255, 167,   0, 208, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 104,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 104, 255, 255, 
255,   0,   0, 255, 189,   0,   0,   0, 255, 255, 255, 104,   0, 255, 255, 255, 
255,   0, 104, 255, 255, 255, 104,   0, 255, 255, 255, 255,   0, 104, 255, 255, 
255, 104,   0, 255, 255, 255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255, 
255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255, 255, 255,   0, 104, 255, 
255, 255, 233,  77,   0,  77, 233, 255, 255, 255, 255,   0,  77,  77, 154, 255, 
255,   0, 104, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 199,   0, 167, 255, 255, 
255,   0,   0, 255, 104,   0, 178, 255, 255, 255, 208,   0, 154, 233,   0,   0, 
255, 255, 255, 208,   0, 154, 233,   0,   0, 255, 255, 255, 208,   0, 154, 233, 
  0,   0, 255, 255, 255, 208,   0, 154, 233,   0,   0, 255, 255, 255, 208,   0, 
154, 233,   0,   0, 255, 255, 255, 208,   0, 154, 233,   0,   0, 255, 255, 255, 
199,   0, 154, 225,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 140, 140,   0,   0, 255, 255, 255,   0,   0, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 
255,  77,   0, 240,   0,  77, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 
255, 255,  77,   0, 240,   0,  77, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 
140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 104, 255, 240, 104, 255, 
255, 255, 255, 255, 167,   0,   0, 140, 255, 255, 255, 255, 255, 255, 167, 217, 
199,   0, 199, 255, 255, 255, 208,   0,  77,   0, 104, 255, 178, 240, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 208, 255, 255, 
  0,   0, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 140,   0, 140, 255, 255, 255, 255, 255, 255, 199,   0, 154, 255, 255, 
217, 140, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,  77, 255, 255, 
  0,   0, 225, 217,   0, 154, 255, 255, 255, 233,   0, 124, 255, 255, 255, 255, 
178,   0, 217, 208,   0, 178, 255, 255, 255, 140,   0, 140, 104,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,  77, 225, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
225, 104,   0, 255, 255, 255, 255, 225,  77, 167, 255, 255, 255, 255, 104, 233, 
167,   0, 167, 255, 233,   0,   0, 154, 255, 255,   0, 255, 255, 167,   0, 208, 
255, 208,   0, 178, 255, 255, 255,   0,   0, 255, 255, 199,   0, 124, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0,  77, 167,   0, 178, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 225,   0, 
208,   0, 225,   0,   0, 255, 255, 255,   0,   0, 255,  77, 104,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0,   0, 
  0,   0, 167, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 140, 255, 255, 255, 255, 255, 225, 124,   0, 
  0,   0, 208, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255, 217,   0, 154, 255, 154,   0, 217, 
255, 255, 255, 124,   0, 208,   0, 140, 255, 124,   0, 217,   0, 124, 255, 255, 
255, 255, 255, 124,   0, 124, 255, 255, 255, 255, 255, 255, 233,   0,   0, 233, 
255, 255, 255, 255, 255, 124,   0, 225, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 208, 167, 255, 255, 255,   0,   0, 255, 255, 140,   0, 240, 240,   0, 140, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 225, 178, 124,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,  77, 
255, 255, 255,  77,   0, 255, 255, 255, 255, 255, 255,  77,   0, 255, 255,   0, 
  0, 255, 255, 255,  77,   0, 255, 255,   0, 104, 255, 255, 255,   0,   0, 255, 
255, 255,  77,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
 77, 124, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 
255, 104,   0, 255, 255,   0, 104, 255, 255, 255,   0,   0, 255, 255,   0,  77, 
255, 255, 255,  77,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255,  77,   0, 124, 208, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255,   0,   0, 255, 255, 208,   0, 167, 255, 167,   0, 208, 255, 233,   0, 
124, 255,   0,   0,  77, 255, 124,   0, 233, 255, 255, 255, 104,  77,  77, 104, 
255, 255, 255, 225,   0, 140, 255, 140,   0, 217, 255, 255, 255, 255, 104,  77, 
255, 255, 255, 225,   0, 178, 255, 255, 255, 255,   0, 255, 255, 255, 255, 178, 
  0, 225, 255, 189,  77,  77, 167, 233, 255, 178, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,  77,   0, 233, 140, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 240,  77,   0, 140, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,  77, 178, 255,  77, 178, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 124, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 178, 
 77, 255, 178,  77, 255, 255, 255, 255, 255, 208, 167, 255, 255, 225,   0, 255, 
255, 255, 255, 255, 255, 225, 140, 255, 208,  77,   0, 189, 255, 255, 255, 255, 
255, 255, 255, 104, 255, 255, 225,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 167,   0, 208, 255, 208,   0, 178, 255, 255, 255, 167,   0, 
208, 255, 208,   0, 178, 255, 255, 255, 167,   0, 208, 255, 208,   0, 178, 255, 
255, 255, 167,   0, 208, 255, 208,   0, 178, 255, 255, 255, 167,   0, 208, 255, 
208,   0, 178, 255, 255, 255, 167,   0, 208, 255, 208,   0, 178, 255, 255, 255, 
233,   0, 124, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255,  77, 104,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 233,  77,   0,  77, 233, 
255, 255, 255, 255,   0,   0, 217,   0, 189, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 233,   0,   0, 233, 255, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 189,   0, 124, 255, 
255, 255, 255, 255, 225, 178, 124,   0,   0, 255, 255, 255, 255, 225, 178, 124, 
  0,   0, 255, 255, 255, 255, 225, 178, 124,   0,   0, 255, 255, 255, 255, 225, 
178, 124,   0,   0, 255, 255, 255, 255, 225, 178, 124,   0,   0, 255, 255, 255, 
255, 225, 178, 124,   0,   0, 255, 255, 255, 255, 225, 178, 124,   0,   0, 255, 
255,   0, 104, 255, 255, 255,  77,   0, 255, 255, 255, 255, 255, 255,  77,   0, 
255, 255,   0, 104, 255, 255, 255,  77,   0, 255, 255,   0, 104, 255, 255, 255, 
 77,   0, 255, 255,   0, 104, 255, 255, 255,  77,   0, 255, 255,   0, 104, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255, 104,   0, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255, 104,   0, 255, 255,   0, 104, 255, 255, 
255, 104,   0, 255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255,   0, 104, 
255, 255, 255, 104,   0, 255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255, 
  0, 104, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,  77,   0, 225, 
  0,   0, 140, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255,   0,   0, 255, 255, 225,   0, 140, 255, 140,   0, 217, 
255, 255,   0,   0, 255, 255,   0,  77, 255, 255, 225,   0, 140, 255, 140,   0, 
217, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 140, 140, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 104, 255, 255, 104, 255, 255, 255, 255, 178,   0,   0, 140, 
233, 255, 255, 255, 199,   0, 199, 225, 154, 255, 255, 255, 255, 255, 255, 255, 
217,  77,   0, 189, 255, 255, 255, 255, 255, 255, 255, 255, 255, 124,   0, 255, 
255, 255,   0, 124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 208, 167, 255, 255,   0,   0, 255, 255,   0,   0, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 104,   0, 199, 255, 
255, 255, 255, 104,   0, 104, 255, 255, 255, 255, 104, 225,   0,   0, 255, 255, 
255, 140,   0, 233, 199,   0, 167, 255, 255,   0, 104, 140,   0, 140, 255, 255, 
255, 255, 255, 104,   0, 240, 255, 255, 255, 255, 104,   0,   0,   0, 240, 255, 
255, 154,   0, 217, 225,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 189,  77,   0, 124, 199, 240, 255, 255, 255,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255, 240, 199, 124,   0,  77, 189, 255, 255, 255, 255, 
255, 233,   0, 124, 233, 255, 255, 167, 189, 240,  77,   0,   0,   0,  77,   0, 
 77, 255, 255,   0, 255, 255, 217,   0, 154, 255, 154,   0, 217, 255, 255, 255, 
  0,   0,   0,   0,   0, 124, 240, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
  0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0,  77,   0,   0, 240, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 189,   0, 255,   0, 189,   0,   0, 255, 255, 
255,   0,   0, 189,   0, 208,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 189,   0, 167, 255, 255, 255, 
  0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 199, 
  0, 154, 255, 255, 255, 208,   0,   0,   0, 140, 225, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255, 167,   0, 208, 255, 199,   0, 167, 255, 255, 255,   0,   0, 255,  77, 
  0, 255,   0,  77, 255,   0,   0, 255, 255, 255, 255, 255, 124,   0, 124, 255, 
255, 255, 255, 255, 255, 140,   0,   0, 140, 255, 255, 255, 255, 255, 233,   0, 
104, 255, 255, 255, 255,   0,   0, 255, 255, 255, 167, 208, 255, 255, 255,   0, 
  0, 255, 255, 225,   0, 199, 199,   0, 217, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 124, 217, 255, 233,   0,  77, 
255, 255, 255,   0,   0, 167, 199,   0, 167, 255, 255, 255, 178,   0, 199, 233, 
  0, 140, 255, 255, 167,   0, 199, 167,   0,   0, 255, 255, 255, 167,   0, 199, 
208,   0, 189, 255, 255, 255,   0,   0, 255, 255, 255, 167,   0, 199, 167,   0, 
  0, 255, 255, 255,   0,   0, 167, 233,   0, 104, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 233,   0, 167, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 199, 240,   0,   0, 189, 233,   0, 104, 255, 255, 
255,   0,   0, 199, 233,   0,  77, 255, 255, 255, 189,   0, 199, 199,   0, 189, 
255, 255, 255,   0,   0, 167, 199,   0, 167, 255, 255, 255, 167,   0, 199, 167, 
  0,   0, 255, 255, 255,   0,   0, 217, 255, 255, 104,   0, 255, 233,   0, 124, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 104, 
  0, 240, 255, 240,   0, 104, 255, 178,   0, 199, 255, 140,   0, 154, 255, 199, 
  0, 178, 255, 255, 189,   0, 199, 189,   0, 189, 255, 255, 178,   0, 199, 255, 
199,   0, 178, 255, 255, 255, 255, 217,   0, 167, 255, 255, 255,   0,  77, 255, 
255, 255, 255,   0, 255, 255, 255, 255,  77,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 178,   0, 199,  77,  77, 140, 
255, 255, 255, 104,   0, 217, 255, 255, 255, 255,   0, 167, 255, 255, 167,   0, 
255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 178,   0, 
124,   0,  77, 240, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 178,   0, 104,  77, 255, 255, 255, 217, 104, 255, 
217, 104, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 233, 140, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 104,   0,   0,   0, 255, 208,  77,  77, 199, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 154,   0,   0, 255,   0, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 217,  77,  77, 217, 255, 255, 104, 217, 255, 104, 217, 255, 255, 255, 
  0, 255, 255, 140, 225, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 154, 
217, 255, 255, 255, 255, 255, 255, 208,  77,  77, 199, 255, 208, 178, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 217,   0, 154, 
255, 154,   0, 217, 255, 255, 255, 217,   0, 154, 255, 154,   0, 217, 255, 255, 
255, 217,   0, 154, 255, 154,   0, 217, 255, 255, 255, 217,   0, 154, 255, 154, 
  0, 217, 255, 255, 255, 217,   0, 154, 255, 154,   0, 217, 255, 255, 255, 217, 
  0, 154, 255, 154,   0, 217, 255, 255, 255, 255, 124,   0, 233, 255,   0,   0, 
  0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255,   0,   0, 
255, 255, 255,   0,   0, 189,   0, 208,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 
  0, 255, 255, 233,  77, 124, 240, 124,  77, 233, 255, 255, 255,   0,   0, 255, 
189,   0, 217,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 140,   0,   0, 140, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 140,   0, 255, 255, 255, 255, 255, 124, 217, 255, 233, 
  0,  77, 255, 255, 255, 124, 217, 255, 233,   0,  77, 255, 255, 255, 124, 217, 
255, 233,   0,  77, 255, 255, 255, 124, 217, 255, 233,   0,  77, 255, 255, 255, 
124, 217, 255, 233,   0,  77, 255, 255, 255, 124, 217, 255, 233,   0,  77, 255, 
255, 255, 140, 217, 255, 233,   0,   0, 208, 217,   0, 189, 255, 255, 255, 178, 
  0, 199, 233,   0, 140, 255, 255, 167,   0, 199, 208,   0, 189, 255, 255, 255, 
167,   0, 199, 208,   0, 189, 255, 255, 255, 167,   0, 199, 208,   0, 189, 255, 
255, 255, 167,   0, 199, 208,   0, 189, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 189, 
  0, 199, 199,   0, 124, 255, 255, 255,   0,   0, 199, 233,   0,  77, 255, 255, 
255, 189,   0, 199, 199,   0, 189, 255, 255, 255, 189,   0, 199, 199,   0, 189, 
255, 255, 255, 189,   0, 199, 199,   0, 189, 255, 255, 255, 189,   0, 199, 199, 
  0, 189, 255, 255, 255, 189,   0, 199, 199,   0, 189, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 167,   0, 208, 167,   0, 217, 255, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 
255, 255, 178,   0, 199, 255, 199,   0, 178, 255, 255,   0,   0, 199, 199,   0, 
167, 255, 255, 178,   0, 199, 255, 199,   0, 178, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 104, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0, 255, 255, 255,  77, 124,   0, 255, 255, 255, 255, 255,  77, 240,  77, 
255, 104, 240, 255, 255, 255, 255, 255, 255, 208,   0,  77,   0, 199, 255, 255, 
255, 255, 255, 255, 255, 255, 167,   0, 225, 255, 225,   0, 167, 255, 255, 154, 
167, 225, 178, 154, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  77, 
255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 255, 140, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 225,   0,  77, 255, 255, 255, 255, 255, 189,   0, 154, 
255, 255, 255, 208, 167,   0,   0, 255, 255, 255, 140,   0,  77,   0, 140, 255, 
255, 255,  77,   0, 255, 255, 255, 255, 255, 255, 255, 255, 208,   0, 178, 255, 
255, 255, 154,   0, 225, 225,   0, 167, 255, 255,   0,   0, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 208, 104, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 104, 208, 255, 255, 255, 255, 255, 255, 255, 255, 208,   0, 104, 255, 255, 
225,  77, 255, 233, 140,   0, 104, 208,   0,   0, 240, 208, 154, 255, 255, 255, 
 77,   0, 240,   0,  77, 255, 255, 255, 255,   0,   0, 255, 255, 225,   0, 178, 
255, 255, 255, 124,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255,   0, 104, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 104,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 208,   0, 124, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
140, 140, 255, 140, 140,   0,   0, 255, 255, 255,   0,   0,  77, 104, 255,   0, 
  0, 255, 255, 255, 104,   0, 255, 255, 255, 255,   0, 104, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255, 104,   0, 255, 255, 255, 255,   0, 
124, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 104,   0, 
104, 225, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 104,   0, 240, 255, 240, 
  0,  77, 255, 255, 225,   0, 140, 255, 154,   0, 189,   0, 154, 255, 140,   0, 
225, 255, 255, 255, 199,   0,   0,   0, 199, 255, 255, 255, 255, 208,   0, 167, 
167,   0, 208, 255, 255, 255, 255, 255, 178,   0, 199, 255, 255, 255,   0,   0, 
255, 255, 255,  77, 255, 255, 255, 255,   0,   0, 255, 255, 255, 104, 124, 124, 
104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 233, 140,   0,   0, 104, 217, 255, 255, 255,   0,   0, 199,  77, 
140, 255, 255, 255, 255, 255, 178,  77,   0, 140, 233, 255, 255, 255, 140, 104, 
208,   0,   0, 255, 255, 255, 255, 154,   0,   0, 178, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 140,  77, 189,   0,   0, 255, 255, 255,   0,   0, 208, 
 77,  77, 208, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 208,   0, 167, 255, 255,   0,   0, 255, 255, 255,   0,   0, 208, 
 77,  77, 189, 189,  77,  77, 208, 255, 255, 255,   0,   0, 225,  77,  77, 208, 
255, 255, 255, 255, 178,  77,   0, 178, 255, 255, 255, 255,   0,   0, 208,  77, 
124, 255, 255, 255, 255, 255, 140,   0, 208,   0,   0, 255, 255, 255,   0,   0, 
140, 124, 255, 233, 124,   0,   0, 140, 233, 255,   0,   0,   0,   0, 255, 255, 
  0,   0, 255, 255,   0,   0, 255, 225,   0, 140, 255, 255, 255, 140,   0, 255, 
104,   0, 240, 255, 189,   0, 208, 255, 255,   0, 104, 255, 233,   0, 124, 255, 
255, 124,   0, 233, 255, 104,   0, 240, 255, 240,   0, 104, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 178,   0,   0, 140, 233, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 167,   0,   0,   0,   0,   0,   0, 167, 255, 255,  77,  77, 104,  77, 
255, 255, 255, 255,   0, 255, 255, 255, 140,   0, 124, 240, 255, 255, 255, 255, 
255, 255, 255, 255, 140, 217, 255, 154, 199, 225, 104, 255, 217, 140, 255,   0, 
240, 233,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 140, 217, 255,   0, 255, 
233,  77, 255, 217, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 208,  77, 
 77, 208, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 233, 124, 225, 255, 
255, 104, 233, 240,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255,   0, 
  0, 255, 255, 140,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 104, 233, 225, 104, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 225, 140, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 240, 124, 255, 255, 255, 255, 255, 255, 
104, 233, 240,   0, 255, 255, 124, 240, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,  77,   0, 240,   0,  77, 255, 255, 255, 255, 
255,  77,   0, 240,   0,  77, 255, 255, 255, 255, 255,  77,   0, 240,   0,  77, 
255, 255, 255, 255, 255,  77,   0, 240,   0,  77, 255, 255, 255, 255, 255,  77, 
  0, 240,   0,  77, 255, 255, 255, 255, 255,  77,   0, 240,   0,  77, 255, 255, 
255, 255, 255, 208,   0, 167, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
124,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0, 104, 255, 255, 255,   0,   0,  77, 104, 
255,   0,   0, 255, 255, 255, 104,   0, 255, 255, 255, 255,   0, 104, 255, 255, 
255, 104,   0, 255, 255, 255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255, 
255, 255,   0, 104, 255, 255, 255, 104,   0, 255, 255, 255, 255,   0, 104, 255, 
255, 255, 104,   0, 255, 255, 255, 255,   0, 104, 255, 255, 240, 167, 255, 255, 
255, 140, 255, 255, 255, 255, 104,   0, 255, 255, 154,  77,  77, 124, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255, 208,   0, 167, 167,   0, 208, 255, 
255, 255,   0,   0, 255, 255, 199,   0, 154, 255, 255, 255,   0,   0, 199,   0, 
199, 255, 255, 255, 255, 233, 140,   0,   0, 104, 217, 255, 255, 255, 233, 140, 
  0,   0, 104, 217, 255, 255, 255, 233, 140,   0,   0, 104, 217, 255, 255, 255, 
233, 140,   0,   0, 104, 217, 255, 255, 255, 233, 140,   0,   0, 104, 217, 255, 
255, 255, 233, 140,   0,   0, 104, 217, 255, 255, 255, 233, 154,   0,   0, 104, 
189,   0,   0, 167, 255, 255, 255, 255, 255, 178,  77,   0, 140, 233, 255, 255, 
255, 154,   0,   0, 178, 255, 255, 255, 255, 255, 154,   0,   0, 178, 255, 255, 
255, 255, 255, 154,   0,   0, 178, 255, 255, 255, 255, 255, 154,   0,   0, 178, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 167,   0,  77, 104, 178, 255, 255, 
255,   0,   0, 225,  77,  77, 208, 255, 255, 255, 255, 178,  77,   0, 178, 255, 
255, 255, 255, 255, 178,  77,   0, 178, 255, 255, 255, 255, 255, 178,  77,   0, 
178, 255, 255, 255, 255, 255, 178,  77,   0, 178, 255, 255, 255, 255, 255, 178, 
 77,   0, 178, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
140,   0,   0,  77, 208, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 104,   0, 240, 255, 240, 
  0, 104, 255, 255,   0,   0, 178,   0, 140, 255, 255, 255, 104,   0, 240, 255, 
240,   0, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 140, 
140, 255, 140, 140, 255, 255, 189, 178, 255, 189, 178, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 199, 189, 255, 255, 255, 255, 
255, 255,  77,   0, 225,   0,  77, 255, 255, 255, 255, 140, 140, 255, 255, 225, 
  0, 208, 255, 208,   0, 225, 255, 255, 255, 140,   0, 140, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 140, 225, 255, 124,   0, 255, 255,   0, 
124, 255, 255, 255,   0, 124,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 104,   0,   0, 
255, 255, 255, 189,   0, 208, 255, 255, 255, 255, 255, 154,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 104,  77, 255, 255, 255,   0,   0, 255, 255,   0, 
  0, 255, 255,   0,   0, 255, 255,   0, 140, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 140, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 140, 217, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 178, 124, 255, 255, 255, 255, 
255, 255, 255, 240,  77, 225, 255, 255, 255, 167,   0, 140,   0, 167, 255, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 189,   0, 217, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 225,   0, 167, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 178,   0, 208, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 178,   0, 199, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,  77, 189, 255, 189,  77,   0,   0, 
255, 255, 255,   0,   0,   0, 208, 255,   0,   0, 255, 255, 255, 167,   0, 208, 
255, 255, 217,   0, 167, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255, 167,   0, 208, 255, 255, 208,   0, 189, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 233,   0, 124, 255, 255, 255, 124,   0, 233, 255, 189,   0, 178, 
255, 199,   0,   0,   0, 199, 255, 178,   0, 189, 255, 255, 255,  77,  77, 240, 
 77,  77, 255, 255, 255, 255,  77,  77, 255, 255,  77,  77, 255, 255, 255, 255, 
255, 255, 104,  77, 255, 255, 255,   0,   0, 255, 255, 225, 140, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 208,   0,   0, 208, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 178, 
199, 255, 255, 255, 255,  77,   0, 255, 255, 255, 255, 255, 167, 255, 255, 255, 
255, 167, 255, 255, 233,   0, 167, 167,   0, 233, 255, 255, 255,   0, 255, 255, 
255,   0,   0, 240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 124, 255, 
233, 104,  77, 217, 255, 124, 217, 255, 199, 104, 140,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 217, 124, 255,   0,   0,   0, 225, 255, 124, 217, 255, 255, 
255, 255, 255, 255, 255, 255, 255,  77, 233, 233,  77, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 140, 208, 255, 255, 255,   0, 154, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 167, 208, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 189, 189, 255, 255, 255, 255, 255, 255, 255,   0, 154, 255, 255, 225, 
140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
167,   0, 140,   0, 167, 255, 255, 255, 255, 255, 167,   0, 140,   0, 167, 255, 
255, 255, 255, 255, 167,   0, 140,   0, 167, 255, 255, 255, 255, 255, 167,   0, 
140,   0, 167, 255, 255, 255, 255, 255, 167,   0, 140,   0, 167, 255, 255, 255, 
255, 255, 167,   0, 140,   0, 167, 255, 255, 255, 255, 255, 255,  77,  77, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 189,   0, 217, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 225, 
  0, 167, 255, 255, 255,   0,   0,   0, 208, 255,   0,   0, 255, 255, 255, 167, 
  0, 208, 255, 255, 217,   0, 167, 255, 255, 255, 167,   0, 208, 255, 255, 217, 
  0, 167, 255, 255, 255, 167,   0, 208, 255, 255, 217,   0, 167, 255, 255, 255, 
167,   0, 208, 255, 255, 217,   0, 167, 255, 255, 255, 167,   0, 208, 255, 255, 
217,   0, 167, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 
  0, 217, 255, 255, 124,   0, 167, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,  77,  77, 255, 255,  77,  77, 255, 255, 255,   0,   0,   0,   0,   0, 
140, 255, 255, 255, 255,   0,   0, 240,   0,  77, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 225, 178, 233, 104, 240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255,   0,   0, 255, 255, 225, 
140, 255, 225, 140, 255, 255, 255, 124, 208,   0, 208, 104, 255, 255, 255,  77, 
240,  77, 255, 255, 104, 255, 255, 255, 255, 255, 255, 104,   0, 240,   0, 104, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 104, 167, 255, 167, 104, 255, 255, 
255, 140, 154, 104, 167, 154, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 199, 178, 255, 178,   0, 199, 199,   0, 178, 255, 255, 255, 233, 140,   0, 
  0, 255, 255, 255, 104,   0, 233, 233,   0, 167, 255, 255, 154,   0, 233, 225, 
  0, 140, 255, 255, 255, 255, 199,   0,   0, 255, 255, 255, 217,   0, 154, 255, 
255, 255, 255, 255, 225,   0, 199, 233,   0, 154, 255, 255, 255, 255, 255, 217, 
  0, 154, 255, 255, 140,   0, 225, 225,   0, 140, 255, 255, 167,   0, 225, 199, 
  0, 189, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 124,   0, 208, 255, 199,   0, 178, 
255, 255, 255, 255, 178, 104, 199, 240, 255, 255, 240, 199,  77, 208, 255, 255, 
255, 255, 217,   0,   0,   0, 217, 255, 255, 255, 255,   0,   0, 255, 255, 225, 
  0, 104, 255, 255, 255, 255, 124, 104, 240, 255, 199,   0, 140, 255, 255,   0, 
  0, 255, 255, 154,   0, 233, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 124, 104, 233, 255, 
199,   0, 140, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 140,   0, 217, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 217, 255, 217,   0,   0,   0, 255, 255, 255,   0,   0, 104, 255, 
255,   0,   0, 255, 255, 255, 240,  77, 124, 240, 240, 124,  77, 240, 255, 255, 
255,   0,   0, 255, 255, 199,   0, 154, 255, 255, 255, 240,  77, 124, 240, 240, 
104,  77, 255, 255, 255, 255,   0,   0, 255, 255, 217,   0, 154, 255, 255, 255, 
167,   0, 225, 255, 217,   0, 104, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 178,   0, 199, 255, 
255, 255, 189,   0, 178, 255, 154,   0, 217, 255, 233,   0,   0,   0, 233, 255, 
217,   0, 154, 255, 255, 167,   0, 199, 255, 199,   0, 167, 255, 255, 178,   0, 
199, 255, 255, 199,   0, 178, 255, 255, 255, 255, 255, 217,   0, 167, 255, 255, 
  0,   0, 255, 255, 178, 199, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
104,  77, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
167, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,  77,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 140, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 124,   0, 233, 255, 255, 255,   0, 255, 
255, 255, 233,   0, 124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 208, 154, 255, 255, 255, 255, 178,   0, 
225, 233,   0, 154, 255, 255, 255, 255, 255, 255, 255, 255, 255, 178,   0, 208, 
208,   0, 178, 255, 255, 255,   0, 255, 255, 255, 104,   0, 240,   0, 104, 255, 
255, 255, 255, 255, 255, 255, 255, 167, 124, 217, 255, 255, 217, 124, 167, 255, 
255, 104, 233, 240,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 124, 
217, 255, 255, 217, 124, 167, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
 77, 233, 233,  77, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  77, 233, 
255,   0, 255, 124, 233, 240,   0, 255, 255, 140, 167, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 124,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 140,   0, 255, 255, 255, 104, 233, 225, 
104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140,   0, 255, 255, 255, 255, 
124, 255, 255, 255, 255, 255, 140,   0, 255, 255, 255, 255, 104, 240, 255, 255, 
255, 255, 124, 233, 240,   0, 255, 255, 255, 154, 225, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 217,   0,   0,   0, 217, 255, 255, 
255, 255, 255, 217,   0,   0,   0, 217, 255, 255, 255, 255, 255, 217,   0,   0, 
  0, 217, 255, 255, 255, 255, 255, 217,   0,   0,   0, 217, 255, 255, 255, 255, 
255, 217,   0,   0,   0, 217, 255, 255, 255, 255, 255, 217,   0,   0,   0, 217, 
255, 255, 255, 255, 255, 255, 167,   0, 208,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 124, 104, 240, 255, 199,   0, 140, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 154,   0, 233, 255, 255, 255,   0,   0, 
104, 255, 255,   0,   0, 255, 255, 255, 240,  77, 124, 240, 240, 124,  77, 240, 
255, 255, 255, 240,  77, 124, 240, 240, 124,  77, 240, 255, 255, 255, 240,  77, 
124, 240, 240, 124,  77, 240, 255, 255, 255, 240,  77, 124, 240, 240, 124,  77, 
240, 255, 255, 255, 240,  77, 124, 240, 240, 124,  77, 240, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 240,  77, 104, 240, 255, 154,   0, 154, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 178,   0, 199, 255, 255, 199, 
  0, 178, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 154,   0, 
233,   0,  77, 255, 255, 255, 255, 255, 255, 167, 140, 255, 255, 255, 255, 255, 
255, 255, 140, 167, 255, 255, 255, 255, 255, 255, 255, 140, 189, 140, 255, 255, 
255, 255, 255,   0, 240, 140, 140, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 208,  77,  77, 208, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 167, 140, 255, 255, 255, 255, 255, 255, 255, 140, 167, 255, 
255, 255, 255, 255, 255, 140, 189, 140, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 167, 140, 255, 255, 255, 140, 167, 255, 255, 255, 
140, 189, 140, 255,   0, 255, 255,   0, 255, 255, 255, 255, 178,   0, 233, 255, 
255, 255, 255, 255,   0, 240, 140, 140, 255, 255, 255, 255, 255, 255, 255, 167, 
140, 255, 255, 255, 255, 255, 255, 140, 167, 255, 255, 255, 255, 255, 255, 255, 
140, 189, 140, 255, 255, 255, 255, 255,   0, 240, 140, 140, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 140, 255, 255, 
255, 255, 255, 255, 255, 140, 167, 255, 255, 255, 255, 255, 255, 255, 140, 189, 
140, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
140, 167, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255,   0,   0, 255, 255, 255,  77, 255, 255,  77, 255, 255, 255, 
233, 104,   0, 104, 233, 255, 255, 255, 199,   0, 199, 255, 255, 167, 217, 255, 
255, 255, 255, 255, 233, 104,   0, 104, 233, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 217, 104, 255, 104, 217, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 104, 255, 255, 167,   0, 
  0, 167, 255, 255, 255, 255, 255, 255, 154,   0, 255, 255, 255, 233, 124,   0, 
  0, 167, 255, 255, 255, 233, 154,   0,   0, 154, 255, 255, 255, 255, 255, 255, 
 77,   0, 255, 255, 255, 240,   0,   0,   0,   0,   0, 255, 255, 255, 208, 104, 
  0, 104, 233, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 233, 154,   0, 
  0, 154, 240, 255, 255, 255, 167,   0,  77, 178, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 240, 167,  77,   0,  77, 189, 255, 255, 255, 255, 255, 255, 225, 167, 
104,   0,   0, 104, 167, 233, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0, 124, 233, 255, 255, 255, 255, 255, 
167,  77,   0, 104, 167, 255, 255, 255,   0,   0,   0,   0, 104, 217, 255, 255, 
255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 167,  77,   0,  77, 167, 255, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 104,  77, 233, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 
  0,   0, 255, 255, 255,   0,   0, 208, 255, 255,   0,   0, 255, 255, 255, 255, 
233, 154,   0,   0, 154, 233, 255, 255, 255, 255,   0,   0,   0,   0,   0, 154, 
255, 255, 255, 255, 255, 233, 154,   0,   0, 154, 240, 255, 255, 255, 255,   0, 
  0,   0,   0,   0, 140, 240, 255, 255, 255, 255, 167,  77,   0,   0, 154, 233, 
255, 255,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 104,   0, 233, 255, 255, 255, 233,   0, 104, 255, 104, 
  0, 240, 255, 255,  77,   0,  77, 255, 255, 240,   0, 104, 255, 225,   0, 124, 
255, 255, 255, 124,   0, 225, 233,   0, 124, 255, 255, 255, 255, 124,   0, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0, 255, 104, 240, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 167,   0, 225, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 208,  77,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 233, 154,   0,   0, 255, 255,   0, 255, 255,   0,   0, 140, 233, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 240, 104, 255, 255, 255, 255, 255, 178,  77,   0, 124, 233, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 104,   0, 240, 240,   0, 104, 255, 255, 255,   0, 
255, 255, 255, 233, 104,   0, 104, 233, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 217, 140,   0,   0, 140, 217, 255, 255, 255, 208,  77,   0, 178, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 217, 140,   0,   0, 140, 217, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 208,  77,  77, 208, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 208,  77,   0, 189, 255, 208,  77,  77, 208, 
255, 255, 225,   0, 167, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 140, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 225,  77, 255, 255, 255, 217,  77,  77, 217, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 225,  77, 255, 255, 255, 255, 189, 189, 255, 255, 255, 255, 225, 
 77, 255, 255, 255, 255, 225, 140, 255, 255, 255, 255, 208,  77,  77, 208, 255, 
255, 255, 240, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 208, 255, 255, 255, 255, 255, 255, 233, 
  0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 167,  77,   0, 
104, 167, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0,   0, 
  0, 104, 217, 255, 255, 255, 255,   0,   0, 208, 255, 255,   0,   0, 255, 255, 
255, 255, 233, 154,   0,   0, 154, 233, 255, 255, 255, 255, 255, 233, 154,   0, 
  0, 154, 233, 255, 255, 255, 255, 255, 233, 154,   0,   0, 154, 233, 255, 255, 
255, 255, 255, 233, 154,   0,   0, 154, 233, 255, 255, 255, 255, 255, 233, 154, 
  0,   0, 154, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 233, 154,   0,   0, 167, 208,   0, 208, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 233,   0, 124, 255, 255, 255, 255, 124,   0, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 233, 124,   0, 104, 208, 255, 255, 255, 255, 
255, 167,   0, 225, 255, 255, 255, 255, 255, 255, 255, 225,   0, 167, 255, 255, 
255, 255, 255, 255, 240,   0, 233, 255, 255, 255, 255, 255, 140, 140, 240,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  77, 233, 
233,  77, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167,   0, 225, 255, 
255, 255, 255, 255, 255, 255, 225,   0, 167, 255, 255, 255, 255, 255, 240,   0, 
233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167,   0, 
225, 255, 255, 255, 225,   0, 167, 255, 255, 240,   0, 233, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 124, 167, 178, 255, 255, 255, 255, 255, 140, 140, 240, 
  0, 255, 255, 255, 255, 255, 255, 167,   0, 225, 255, 255, 255, 255, 255, 255, 
225,   0, 167, 255, 255, 255, 255, 255, 255, 240,   0, 233, 255, 255, 255, 255, 
255, 140, 140, 240,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 167,   0, 225, 255, 255, 255, 255, 255, 255, 255, 225,   0, 
167, 255, 255, 255, 255, 255, 255, 240,   0, 233, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 225,   0, 167, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  77, 233, 
233,  77, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 225, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,  77, 233, 233,  77, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 167, 140, 255, 255, 255, 255, 255, 255, 255, 255, 
140, 167, 255, 255, 255, 255, 255, 255, 255, 140, 189, 140, 255, 255, 255, 255, 
255, 255, 255,   0, 240, 140, 140, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,  77, 233, 233,  77, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 140, 255, 255, 255, 255, 255, 
255, 255, 255, 140, 167, 255, 255, 255, 255, 255, 255, 140, 189, 140, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 167, 140, 255, 255, 255, 
140, 167, 255, 255, 255, 140, 189, 140, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 240, 140, 140, 255, 
255, 255, 255, 255, 255, 255, 167, 140, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 140, 167, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 189, 140, 255, 
255, 255, 255, 255, 255, 255,   0, 240, 140, 140, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 167, 140, 255, 255, 255, 255, 255, 255, 255, 140, 167, 255, 255, 255, 255, 
255, 255, 255, 255, 140, 189, 140, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 140, 167, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
208,  77,  77, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 

};

float FontArialW700H16::msCharacterData[257] =
{
0.000218f, 0.005007f, 0.009795f, 0.014584f, 0.019373f, 0.024162f, 0.028951f, 0.033740f, 
0.038529f, 0.043317f, 0.048106f, 0.052895f, 0.057684f, 0.062473f, 0.067262f, 0.072051f, 
0.076839f, 0.081628f, 0.086417f, 0.091206f, 0.095995f, 0.100784f, 0.105572f, 0.110361f, 
0.115150f, 0.119939f, 0.124728f, 0.129517f, 0.134306f, 0.139094f, 0.143883f, 0.148672f, 
0.153461f, 0.155638f, 0.157815f, 0.160862f, 0.164345f, 0.167828f, 0.172616f, 0.176970f, 
0.178711f, 0.180888f, 0.183065f, 0.185677f, 0.189595f, 0.191772f, 0.193949f, 0.196125f, 
0.198302f, 0.201785f, 0.205268f, 0.208751f, 0.212233f, 0.215716f, 0.219199f, 0.222682f, 
0.226165f, 0.229647f, 0.233130f, 0.235307f, 0.237484f, 0.241402f, 0.245320f, 0.249238f, 
0.253156f, 0.259251f, 0.263605f, 0.267958f, 0.272312f, 0.276665f, 0.280583f, 0.284502f, 
0.289290f, 0.293644f, 0.295821f, 0.299303f, 0.303657f, 0.307575f, 0.312799f, 0.317153f, 
0.321942f, 0.326295f, 0.331084f, 0.335438f, 0.339791f, 0.343709f, 0.348063f, 0.352416f, 
0.358511f, 0.362865f, 0.366783f, 0.370266f, 0.372442f, 0.374619f, 0.376796f, 0.380714f, 
0.384197f, 0.386374f, 0.390292f, 0.394210f, 0.397693f, 0.401611f, 0.405529f, 0.407706f, 
0.411624f, 0.415542f, 0.417719f, 0.419896f, 0.423378f, 0.425555f, 0.431215f, 0.435133f, 
0.439051f, 0.442969f, 0.446887f, 0.449499f, 0.452547f, 0.454724f, 0.458642f, 0.462125f, 
0.467349f, 0.471267f, 0.474750f, 0.478232f, 0.480845f, 0.482586f, 0.485198f, 0.489116f, 
0.493905f, 0.498694f, 0.503483f, 0.508272f, 0.513061f, 0.517849f, 0.522638f, 0.527427f, 
0.532216f, 0.537005f, 0.541794f, 0.546583f, 0.551371f, 0.556160f, 0.560949f, 0.565738f, 
0.570527f, 0.575316f, 0.580104f, 0.584893f, 0.589682f, 0.594471f, 0.599260f, 0.604049f, 
0.608838f, 0.613626f, 0.618415f, 0.623204f, 0.627993f, 0.632782f, 0.637571f, 0.642360f, 
0.647148f, 0.649325f, 0.651502f, 0.654985f, 0.658468f, 0.661950f, 0.665433f, 0.667175f, 
0.670657f, 0.672834f, 0.677623f, 0.680235f, 0.683718f, 0.687636f, 0.689813f, 0.694602f, 
0.698084f, 0.700697f, 0.704179f, 0.706356f, 0.708533f, 0.710710f, 0.714192f, 0.717675f, 
0.719852f, 0.722029f, 0.724205f, 0.726818f, 0.730300f, 0.735525f, 0.740749f, 0.745973f, 
0.749891f, 0.754245f, 0.758598f, 0.762952f, 0.767305f, 0.771659f, 0.776012f, 0.782107f, 
0.786461f, 0.790379f, 0.794297f, 0.798215f, 0.802133f, 0.804310f, 0.806487f, 0.808663f, 
0.810840f, 0.815194f, 0.819547f, 0.824336f, 0.829125f, 0.833914f, 0.838703f, 0.843491f, 
0.847410f, 0.852199f, 0.856552f, 0.860906f, 0.865259f, 0.869613f, 0.873531f, 0.877884f, 
0.881802f, 0.885720f, 0.889639f, 0.893557f, 0.897475f, 0.901393f, 0.905311f, 0.910971f, 
0.914454f, 0.918372f, 0.922290f, 0.926208f, 0.930126f, 0.932303f, 0.934480f, 0.936657f, 
0.938833f, 0.942751f, 0.946670f, 0.950588f, 0.954506f, 0.958424f, 0.962342f, 0.966260f, 
0.969743f, 0.973661f, 0.977579f, 0.981498f, 0.985416f, 0.989334f, 0.992817f, 0.996735f, 
1.000218f, 
};

